﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true" CodeBehind="Milestone.aspx.cs" Inherits="GUI.Pages.Milestone" %>
<%@ Register TagPrefix="uc" Namespace="GUI.Controls" Assembly="GUI" %>
<%@ Register Src="~/Controls/MilestoneNavigation.ascx" TagName="MilestoneNavigation" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:MilestoneNavigation ID="MilestoneNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
	<div class="main-form-box">
        <h2>Ključni događaj - osnovni podaci</h2>
        <div class="form-wrapper">
            <div class="row">
                <div class="four columns">
                    <div class="formField ">
                        <asp:HiddenField runat="server" ID="hdnId" />
						<div id="projectHiddenWrapper">
							<asp:HiddenField ID="hdnProjectId" runat="server" />
						</div>
                        <label><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Name %>" /></label>
                        <asp:TextBox runat="server" ID="txtName" />
                        <asp:RequiredFieldValidator ID="txtNameRequired" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="txtName" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* Obavezno polje</asp:RequiredFieldValidator>
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField ">
                        <label><asp:Literal ID="Literal20" runat="server" Text="<%$ Resources:ProjectManagementUI, Task_Finished %>" /></label>
                        <asp:CheckBox runat="server" ID="chkIsClosed" />
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField ">
                        <label>Datum od</label>
                        <telerik:RadDatePicker runat="server" ID="txtStartDate" />
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField">
                        <label>Datum do</label>
                        <telerik:RadDatePicker runat="server" ID="txtEndDate" />
						<asp:CompareValidator ID="dateCompareValidator" runat="server" ControlToValidate="txtEndDate" CssClass="compare-validation-label"
							ControlToCompare="txtStartDate" Operator="GreaterThanEqual" Type="Date" ErrorMessage="<%$ Resources:ProjectManagementUI, Date_error %>"></asp:CompareValidator>
                    </div>
                </div>
				<div class="two columns">
                    <div class="formField">
                       
                    </div>
                </div>
                
            </div>
            
            <div class="row">
                <div class="six columns">
                    <div class="formField ">
                        <label>
                            <asp:Literal ID="Literal38" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Description %>" /></label>
                        <asp:TextBox TextMode="MultiLine" Rows="4" runat="server" ID="txtDescription" />
                    </div>
                </div>
				<div class="six columns">
                    <div class="formField">
                        <label>
                            <asp:Literal ID="Literal58" runat="server" Text="<%$ Resources:ProjectManagementUI, Task_ChooseActivity %>" /></label>
							<telerik:RadAutoCompleteBox ID="radActivityAutocomplete" runat="server" Width="100%" DropDownHeight="150"   DropDownWidth="250" OnClientEntryAdding="OnClientEntryAddingHandler" OnClientRequesting="requesting">
								<WebServiceSettings Method="GetActivities" Path="~/WebService/LoadEntities.asmx" />
							</telerik:RadAutoCompleteBox>
                       
                    </div>
                </div>
                <div class="clear">
                </div>
            </div>

			<br />
				<div class="row">
				
					<div class="twelve columns">
					
						<div class="qsf-demo-canvas qsf-demo-canvas-vertical">
							<telerik:RadPanelBar runat="server" ID="RadPanelBar1" Width="100%" Skin="Office2010Silver" Visible="true">
								<Items>
									<telerik:RadPanelItem Expanded="False" Text="Obavesti korisnike">
										<ContentTemplate>
										        <div class="raw">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="control-label"></label>
                                                            <div class="mt-checkbox-list">
                                                                <label class="mt-checkbox bold"> <asp:Literal ID="Literal25" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_SelectAll %>" />
                                                                    <input type="checkbox" id="chkCheckAll"  onchange="javascript:SelektujSve(this.checked);"/>
                                                                    <span></span>
                                                                </label>
                                                            </div>

                                                            <asp:DataList ID="chkUsers" runat="server" RepeatColumns="10">
                                                                <ItemTemplate>
                                                                     <div class="mt-checkbox-list">
                                                                        <label class="mt-checkbox bold select-users" style="margin-left: 10px;">
                                                                            <asp:CheckBox ID="checkBoxUser" runat="server" Text='<%#Eval("Name") %>'/>
                                                                            <asp:HiddenField ID="hdnuserid" runat="server" Value='<%#Eval("Id") %>' />
                                                                            <span></span>

                                                                        </label>
                                                                    </div>
                                                               
                                                                </ItemTemplate>
                                                            </asp:DataList>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="control-label"><asp:Literal ID="Literal26" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Message %>" /></label>
                                                            <asp:TextBox CssClass="form-control" Rows="3" Width="100%" TextMode="MultiLine" runat="server" ID="txtComment" />
                                                        </div>
                                                    </div>
										        </div>
									        </ContentTemplate>
									</telerik:RadPanelItem>
								</Items>
							</telerik:RadPanelBar>
						</div>
					
					
					</div>

				</div>
            
            <div class="row">
                <div class="twelve columns">
                    <div class="buttonBar">
                        <asp:Button ID="btnSave" OnClick="BtnSaveClick" CssClass="button orange" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                        <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="button" Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                    </div>
                </div>
                <div class="clear">
                </div>
            </div>
        </div>
    </div>
   </telerik:RadAjaxPanel>
   <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1"  >
        <div class="updatePanelProgress"><asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel> 
    <script type="text/javascript">
    	function OnClientEntryAddingHandler(sender, eventArgs) {

    		if (sender.get_entries().get_count() == 1) {
    			eventArgs.set_cancel(true);
    			alert("Možete izabrati samo jednu aktivnost");
    		}
    	}

    	function requesting(sender, eventArgs) {
    		var context = eventArgs.get_context();
    		//Data passed to the service.
    		context["ProjectId"] = $('#projectHiddenWrapper input[type=hidden]').val();
    	}
     
    	function SelektujSve(stat) {
    	    var selall = stat;
    	    $('.checkBoxList input').each(function () { $(this).prop('checked', selall) });
    	}
</script>


</asp:Content>
